/* $Id: multisrc.c,v 1.11 1998/07/31 04:34:33 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Don Mathiesen */

/* Two sources are needed for this test, in LA 8 and LA 9. */

#include <stdio.h>		/* For printf */
#include <stdlib.h>		/* For exit */
#include <string.h>		/* For strcmp */
#include <unistd.h>		/* For sleep */
#include "e1432.h"

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

#define SRC_MAX         10

#define GET_INT(parm, msg)                      \
{                                               \
    rtn = sscanf(optarg, "%f", &ftmp);          \
    if ( rtn == 1 )                             \
    {                                           \
        (parm) = (LONGSIZ32)(ftmp + .5);        \
    }                                           \
    else                                        \
   {                                           \
        (void) fprintf(stderr, msg, optarg);    \
        exit(2);                                \
    }                                           \
}

#define GET_FLOAT(parm, msg)                    \
{                                               \
    rtn = sscanf(optarg, "%f", &(parm));        \
    if ( rtn != 1 )                             \
    {                                           \
        (void) fprintf(stderr, msg, optarg);    \
        exit(2);                                \
    }                                           \
}

static void
usage(char *progname)
{
    (void) printf("Usage: %s [tTu] [-m mode] [-b blocksize] [-d dutycycle] [-f clock_freq]\n\
                 [-s span] [-F freq]\n"
		  "\t-b: blocksize\n"
		  "\t-d: burst duty cycle, float\n"
		  "\t-f: clock freq, float\n"
		  "\t-m: use source mode <mode>, choices are:\n"
		  "\t    sine bsine rand brand randz brandz\n"
		  "\t-s: span, float\n"
		  "\t-t: use source trigger\n"
		  "\t-F: sine or center freq, float\n"
		  "\t-S: single channel per sca\n"
		  "\t-T: use manual arm, manual trigger\n"
		  "\t-u: print this usage message\n",
		  progname);
    exit(1);
}

int
main(int argc, char **argv)
{
    struct e1432_hwconfig hwconfig[2];
    int     src_count, status, trig, mtrig=0, mode, c, i;
    int rtn, tmp, doitforever;
    SHORTSIZ16 src_group;
    SHORTSIZ16 src_list[SRC_MAX];
    SHORTSIZ16 laddr[2];
    SHORTSIZ16 numaddr;
    SHORTSIZ16 meas_state;
    E1432ID hw;
    LONGSIZ32 src_blocksize = 1024;
    float burst_dutycycle =.9;
    float ftmp;
    float clock_freq = 0;
    float center_freq = 5000;
    float span = 0;
    int single_chan = 0;

    trig = 0;
    mode = E1432_SOURCE_MODE_SINE;
    while ((c = getopt(argc, argv, "b:d:f:m:s:tF:STu")) != EOF)
	switch (c)
	{
	case 'b':
	    GET_INT(tmp, " block size %s not converted");
	    src_blocksize = tmp;
	    break;
	case 'd':
	    GET_FLOAT(ftmp, " burst duty cycle %s not converted");
	    burst_dutycycle = ftmp;
	    break;
	case 'f':
	    GET_FLOAT(ftmp, " clock_freq %s not converted");
	    clock_freq = ftmp;
	    break;
	case 'm':
	    if (strcmp(optarg, "sine") == 0)
		mode = E1432_SOURCE_MODE_SINE;
	    else if (strcmp(optarg, "bsine") == 0)
		mode = E1432_SOURCE_MODE_BSINE;
	    else if (strcmp(optarg, "rand") == 0)
		mode = E1432_SOURCE_MODE_RAND;
	    else if (strcmp(optarg, "brand") == 0)
		mode = E1432_SOURCE_MODE_BRAND;
	    else if (strcmp(optarg, "randz") == 0)
		mode = E1432_SOURCE_MODE_RANDZ;
	    else if (strcmp(optarg, "brandz") == 0)
		mode = E1432_SOURCE_MODE_BRANDZ;
	    else
		usage(argv[0]);
	    break;
	case 's':
	    GET_FLOAT(ftmp, " span %s not converted");
	    span = ftmp;
	    break;
	case 't':
	    trig = 1;
	    break;
	case 'S':
	    single_chan = 1;
	    break;
	case 'F':
	    GET_FLOAT(ftmp, " center or sine freq %s not converted");
	    center_freq = ftmp;
	    break;
	case 'T':
	    mtrig = 1;
	    break;
	case '?':
	case 'u':
	    usage(argv[0]);
	    break;
	}

    switch (mode)
    {
    case E1432_SOURCE_MODE_SINE:
	(void) printf("Source mode Sine\n");
	break;
    case E1432_SOURCE_MODE_BSINE:
	(void) printf("Source mode Burst Sine\n");
	break;
    case E1432_SOURCE_MODE_RAND:
	(void) printf("Source mode Random\n");
	break;
    case E1432_SOURCE_MODE_BRAND:
	(void) printf("Source mode Burst Random\n");
	break;
    case E1432_SOURCE_MODE_RANDZ:
	(void) printf("Source mode Zoom Random\n");
	break;
    case E1432_SOURCE_MODE_BRANDZ:
	(void) printf("Source mode Burst Zoom Random\n");
	break;
    }

    if (trig)
	(void) printf("Source trigger\n");
    else
	if (mtrig)
	    (void) printf("Manual trigger\n");
	else
	    (void) printf("Auto trigger\n");

    /* Initialize library */
    CHECK(e1432_init_io_driver());

    laddr[0] = 8;
    laddr[1] = 9;
    numaddr = 2; 

    /* Install sema.bin if needed */
    status = e1432_get_hwconfig(numaddr, laddr, hwconfig);
    CHECK(e1432_print_errors(1));
    if (status < 0)
    {
	CHECK(e1432_install(numaddr, laddr, 0, "/opt/e1432/lib/sema.bin"));
	CHECK(e1432_get_hwconfig(numaddr, laddr, hwconfig));
    }
	CHECK(e1432_assign_channel_numbers(numaddr, laddr, &hw));

	src_count = hwconfig[0].source_chans + hwconfig[1].source_chans;
	(void) printf("Source channels = %d\n", src_count);

    /* Create channel group */
    for ( ; ; )
    {
	CHECK(e1432_assign_channel_numbers(numaddr, laddr, &hw));

	src_count = hwconfig[0].source_chans + hwconfig[1].source_chans;
	if ( src_count > 1)
	{
	    if (src_count > SRC_MAX)
            src_count = SRC_MAX;
	    for (i = 0; i < src_count; i++)
		src_list[i] = E1432_SOURCE_CHAN(i+1);
	    if (src_count == 4 && single_chan)
	    {
		 /* 1 channel per sca */
		src_list[0] = E1432_SOURCE_CHAN(1);
		src_list[1] = E1432_SOURCE_CHAN(3);
		src_count = 2;
	    }
	    src_group = e1432_create_channel_group(hw, src_count, src_list);
	    if (src_group >= 0)
	    {
		DEBUG((void) printf("e1432_create_channel_group returned %d\n",
				    src_group));
		return -1;
	    }
	}
	else
	{
	    (void) printf("ERROR: need at least 2 sources for this program.\n");
	    return -1;
	}

	if(clock_freq!=0)
	{
	    CHECK(e1432_set_clock_freq(hw, src_group, clock_freq));
	}
	
	if(span!=0)
	{
	    CHECK(e1432_set_span(hw, src_group, span));
	}
	CHECK(e1432_set_active(hw, src_group, E1432_CHANNEL_ON));
	CHECK(e1432_set_source_mode(hw, src_group, mode));
	CHECK(e1432_set_sine_freq(hw, src_group, center_freq));
	CHECK(e1432_set_source_centerfreq(hw, src_group, center_freq));
	CHECK(e1432_set_source_blocksize(hw, src_group, src_blocksize));
	CHECK(e1432_set_duty_cycle(hw, src_group, burst_dutycycle));
	CHECK(e1432_set_range(hw, src_group, 10));
	CHECK(e1432_set_amp_scale(hw, src_group, 0.5));
	CHECK(e1432_get_clock_freq(hw, src_group, &clock_freq));
	printf("clock_freq = %f\n", clock_freq);
	CHECK(e1432_get_span(hw, src_group, &span));
	printf("span = %f\n", span);

/* change scale factors to look for hw channel swap */
/*
	CHECK(e1432_set_amp_scale(hw, src_list[1], 0.05));
	CHECK(e1432_set_amp_scale(hw, src_list[3], 0.05));
*/
	CHECK(e1432_set_ramp_rate(hw, src_group, 0.0));
	CHECK(e1432_set_source_seed(hw, src_group, 0xff));

/* check measurement setup */
/*
	CHECK(e1432_init_measure(hw, src_group));
	sleep (5);
	CHECK(e1432_reset_measure(hw, src_group));
	CHECK(e1432_get_clock_freq(hw, src_group, &clock_freq));
	printf("clock_freq = %f\n", clock_freq);
	CHECK(e1432_get_span(hw, src_group, &span));
	printf("span = %f\n", span);
*/	
	if (mtrig)
	{
	    CHECK(e1432_set_auto_trigger(hw, src_group, E1432_MANUAL_TRIGGER));
	    CHECK(e1432_set_auto_arm(hw, src_group, E1432_MANUAL_ARM));

	    /* Start measurement */
	    CHECK(e1432_init_measure(hw, src_group));

	    doitforever = 1;
    
	    while(doitforever)
	    {
/*		(void) printf("arm_measure \n"); */
		CHECK(e1432_arm_measure(hw, src_group, 1));
/*		(void) printf("trigger_measure \n");*/
		CHECK(e1432_trigger_measure(hw, src_group, 1));
		for(meas_state = 0; meas_state != E1432_MEAS_STATE_IDLE; )
		{
		    CHECK(e1432_get_meas_state(hw, src_group, &meas_state));
/*		    (void) printf("meas_state %d\n",meas_state); */
		}
   
	    }

	}
	if (trig)
	{
	    CHECK(e1432_set_auto_trigger(hw, src_group, E1432_MANUAL_TRIGGER));
/*
	    CHECK(e1432_set_auto_trigger(hw, src_list[0], E1432_AUTO_TRIGGER));
*/
	    CHECK(e1432_set_trigger_channel(hw, src_list[0], E1432_CHANNEL_ON));
	}

	/* Start measurement, which starts the source */
	CHECK(e1432_init_measure(hw, src_group));
	(void) sleep(10);
    }
    /*NOTREACHED*/
    return 0;
}

